/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2008 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.human.dao;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import jp.mosp.common.common.BaseDao;
import jp.mosp.common.common.MospException;

import jp.mosp.human.dto.MKojinDto;

public class MKojinDao  extends BaseDao {

	// e[uyуL[
	public static final String TABLE  = "M_KOJIN"	;
	public static final String KEY_1 	= "KCODE"	;	//ЈR[h

	// 
	public static final String COL_KCODE  		= "KCODE"		;	//ЈR[h
	public static final String COL_SEINENBI  		= "SEINENBI"	;	//N
	public static final String COL_SEIBETU  		= "SEIBETU"		;	//
	public static final String COL_YUBINBAN  		= "YUBINBAN"	;	//X֔ԍ
	public static final String COL_PREFECTURES  	= "PREFECTURES"	;	//s{R[h
	public static final String COL_JYUUSYO1  		= "JYUUSYO1"	;	//Z1
	public static final String COL_JYUUSYO2  		= "JYUUSYO2"	;	//Z2
	public static final String COL_JYUUSYO3  		= "JYUUSYO3"	;	//Z3
	public static final String COL_TEL  			= "TEL"			;	//dbԍ
	public static final String COL_FAX  			= "FAX"			;	//FAXԍ
	public static final String COL_KEITAI  		= "KEITAI"		;	//gєԍ
	public static final String COL_KETUEKI  		= "KETUEKI"		;	//t^
	public static final String COL_SIKAKU  		= "SIKAKU"		;	//i
	public static final String COL_KENKOU  		= "KENKOU"		;	//N
	public static final String COL_TEKIYOU  		= "TEKIYOU"		;	//Ev

	/**
	 * RXgN^
	 */
	public MKojinDao() {
		super();
	}

	/**
	 * ʎ擾(DTOList)
	 * @return List Xg
	 * @throws SQLException
	 */
	private List mappingAll() throws SQLException {
		List<MKojinDto> all = new ArrayList<MKojinDto>();
		while (rs.next()) {
			all.add(mapping());
		}
		return all;
	}

	/**
	 * ʎ擾(DTO)
	 * @return m_kojinDto m_kojinR[h
	 * @throws SQLException
	 */
	private MKojinDto mapping() throws SQLException {
		MKojinDto dto = new MKojinDto();
		dto.setKCode 		(rs.getString (COL_KCODE  		));	//ЈR[h
		dto.setSeinenbi 	(rs.getInt    (COL_SEINENBI  	));	//N
		dto.setSeibetu 		(rs.getString (COL_SEIBETU  	));	//
		dto.setYubinban 	(rs.getString (COL_YUBINBAN  	));	//X֔ԍ
		dto.setPrefectures 	(rs.getInt    (COL_PREFECTURES	));	//s{R[h
		dto.setJyuusyo1 	(rs.getString (COL_JYUUSYO1  	));	//Z1
		dto.setJyuusyo2 	(rs.getString (COL_JYUUSYO2  	));	//Z2
		dto.setJyuusyo3 	(rs.getString (COL_JYUUSYO3  	));	//Z3
		dto.setTel 			(rs.getString (COL_TEL  		));	//dbԍ
		dto.setFax 			(rs.getString (COL_FAX  		));	//Faxԍ
		dto.setKeitai 		(rs.getString (COL_KEITAI  		));	//gєԍ
		dto.setKetueki 		(rs.getString (COL_KETUEKI  	));	//t^
		dto.setSikaku 		(rs.getString (COL_SIKAKU  		));	//i
		dto.setKenkou 		(rs.getString (COL_KENKOU  		));	//N
		dto.setTekiyou 		(rs.getString (COL_TEKIYOU  	));	//Ev
		return dto;
	}

	/**
	 * Sf[^擾
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List findAll() throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			prepareStatement(getSelectQuery(getClass()) + getOrderForKey(getClass()));
			executeQuery();
			List all = mappingAll();
			return all;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * L[ɂf[^擾
	 * @param kcode ЈR[h(L[)
	 * @return m_kojinDto (DTO)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public MKojinDto findForKey(
			String kcode
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()));
			setParam(index++, kcode);
			executeQuery();
			MKojinDto dto = null;
			if (rs.next()) {
				dto = mapping();
				mappingCommonInfo(dto);
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * L[ɂsbN擾
	 * @param kcode ЈR[h(L[)
	 * @return m_kojinDto (DTO)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public MKojinDto findForUpdate(
			String kcode
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()) + getForUpdate());
			setParam(index++, kcode);
			executeQuery();
			MKojinDto dto = null;
			if (rs.next()) {
				dto = mapping();
				mappingCommonInfo(dto);
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * ɂf[^擾
	 * @param kcode ЈR[h
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List findForCondition(
			String kcode
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("WHERE ");
		sb.append(COL_KCODE);
		sb.append(" = ? ");
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++,   kcode  );
			executeQuery();
			List list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * f[^}
	 * @param dto }ΏDTO
	 * @return int }()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int insert(MKojinDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getInsertQuery(getClass()));
			setParams(dto,true);
			executeUpdate();
			chkInsert(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * f[^XV
	 * @param dto XVΏDTO
	 * @return int XV()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int update(MKojinDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getUpdateQuery(getClass()));
			setParams(dto,false);
			setParam(index++, dto.getKCode());
			executeUpdate();
			chkUpdate(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * f[^폜
	 * @param dto XVΏDTO
	 * @return int 폜()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int delete(MKojinDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getDeleteQuery(getClass()));
			setParam(index++, dto.getKCode());
			executeUpdate();
			chkDelete(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * p[^ݒ
	 * @param dto XVΏDTO
	 * @throws SQLException
	 */
	private void setParams(MKojinDto dto,boolean isInsert) throws SQLException {
		setParam(index++, dto.getKCode());			//ЈR[h
		setParam(index++, dto.getSeinenbi());		//N
		setParam(index++, dto.getSeibetu());		//
		setParam(index++, dto.getYubinban());		//X֔ԍ
		setParam(index++, dto.getPrefectures());	//s{R[h
		setParam(index++, dto.getJyuusyo1());		//Z1
		setParam(index++, dto.getJyuusyo2());		//Z2
		setParam(index++, dto.getJyuusyo3());		//Z3
		setParam(index++, dto.getTel());			//dbԍ
		setParam(index++, dto.getFax());			//Faxԍ
		setParam(index++, dto.getKeitai());			//gєԍ
		setParam(index++, dto.getKetueki());		//t^
		setParam(index++, dto.getSikaku());			//i
		setParam(index++, dto.getKenkou());			//N
		setParam(index++, dto.getTekiyou());		//Ev
		setCommonParams(isInsert);
	}

}
